#########################################################################################################
# Analysis for the paper  - Factors Affecting User's Behavioral Intention and Use of a Mobile-Phone-
# Delivered Cognitive Behavioral Therapy for Insomnia: a Small-Scale UTAUT Analysis -
# Table Demographic characteristics of participants
# 2018 TUDelft
# Output file "participants.txt" will be created 
#
# required datafiles
# - 89_beforeimputation.sav
#########################################################################################################

#adjust this to folder that contain data files
setwd("/Users/Siska/Documents/temp-berkas/my work/Corine's paper/BMC/stat/")

########### libraries
library(foreign)
library(MASS)
library(psych)
###########

################################################# Data ##########################################################################
d89=read.spss("Acceptance research/smartpls scripts, data & results/Data/89_beforeImputation.sav", to.data.frame=TRUE, use.value.labels = FALSE, reencode=NA)


# direct output to a file 
sink("Acceptance research/r results/participants.txt", append=FALSE, split=FALSE)
sessionInfo()

# data fields
# PPnr: Participant number
# conditie: Trial condition, 0 <- waiting list, 1 <- app
# AGE: age in years
print("")
cat("\n PARTICIPANTS DEMOGRAPICS \n\n")
cat("1. Participants' Age \n")
cat("     Mean = ") 
mean(d89$AGE)
cat("     SD = ") 
sd(d89$AGE)
user = c(d89$AGE)

# Data fields
# GENDER : 0 -> female, 1 -> male
cat("\n\n2. Participants' Gender \n")
cat("     Female = ") 
gen_f89<-length(which(d89$GEN==0))
gen_f89
cat("          % = ") 
gen_f89/nrow(d89)*100
cat("     Male = ") 
gen_m89<-length(which(d89$GEN==1))
gen_m89
cat("        % = ") 
gen_m89/nrow(d89)*100

# Data fields
# (living) ALONE: 0 or 2 -> No, 1 -> Yes
cat("\n\n3. Participants' Living Together \n")
cat("     Yes = ") 
liv_y89<-length(which(d89$ALONE==1))
liv_y89
cat("       % = ") 
liv_y89/nrow(d89)*100
cat("     No = ") 
liv_n89<-length(which(d89$ALONE==0))
liv_n89
cat("      % = ") 
liv_n89/nrow(d89)*100
G89 = c(liv_y89, liv_n89)
names(G89)=c('Yes', 'No')
liv=as.data.frame(G89)

# Data fields
# (having a) JOB: 0 or 2 -> No, 1 -> Yes
cat("\n\n4. Participants' Having a Job \n")
cat("     Yes = ") 
job_y89<-length(which(d89$JOB==1))
job_y89
cat("       % = ") 
job_y89/nrow(d89)*100
cat("     No = ") 
job_n89<-length(which(d89$JOB==0))
job_n89
cat("      % = ") 
job_n89/nrow(d89)*100

# Data fields
# EDU(cation level): 3 -> Lower general secondary, 4 -> Higher general secondary, 5 -> Community college, 6 -> University
cat("\n\n5. Participants' Education Level \n")
cat("     Lower general secondary = ") 
edu_lo89<-length(which(d89$EDU==3))
edu_lo89
cat("                           % = ") 
edu_lo89/nrow(d89)*100
cat("     High general secondary = ") 
edu_hi89<-length(which(d89$EDU==4))
edu_hi89
cat("                          % = ") 
edu_hi89/nrow(d89)*100
cat("     Community college  = ") 
edu_co89<-length(which(d89$EDU==5))
edu_co89
cat("                      % = ") 
edu_co89/nrow(d89)*100
cat("     University = ") 
edu_un89<-length(which(d89$EDU==6))
edu_un89
cat("              % = ") 
edu_un89/nrow(d89)*100

# Data fields
# SUFF_Y (Duration of Insomnia in years): 0 -> less than 1y, 1 -> 1-5y, 2 -> 5-10y, 3 -> more than 10y, NA-> unclear, 
cat("\n\n6. Participants' Insomnia Duration (years) \n")
cat("     <1 year = ") 
dur_1_89<-length(which(d89$SUFF_Y==0))
dur_1_89
cat("           % = ") 
dur_1_89/nrow(d89)*100
cat("     1-5 year = ") 
dur_5_89<-length(which(d89$SUFF_Y==1))
dur_5_89
cat("            % = ") 
dur_5_89/nrow(d89)*100
cat("     5-10 year = ") 
dur_10_89<-length(which(d89$SUFF_Y==2))
dur_10_89
cat("             % = ") 
dur_10_89/nrow(d89)*100
cat("     >10 year = ") 
dur_20_89<-length(which(d89$SUFF_Y==3))
dur_20_89
cat("            % = ") 
dur_20_89/nrow(d89)*100
cat("     unclear = ") 
dur_unc_89<-length(which(is.na(d89$SUFF_Y)))
dur_unc_89
cat("            % = ") 
dur_unc_89/nrow(d89)*100

# Data fields
# (Insomnia due to a) PHYSIC(al condition): 2 -> No, 1 -> Yes
cat("\n\n7. Insomnia due to a Physical Condition \n")
cat("     Yes = ") 
phys_y89<-length(which(d89$PHYSIC==1))
phys_y89
cat("       % = ") 
phys_y89/nrow(d89)*100
cat("     No = ") 
phys_n89<-length(which(d89$PHYSIC==2))
phys_n89
cat("      % = ") 
phys_n89/nrow(d89)*100

# Data fields
# (Use of) MED: NA -> No, 1 -> Yes
cat("\n\n8. Use Medication \n")
cat("     Yes = ") 
med_y89<-length(which(!is.na(d89$MED)))
med_y89
cat("       % = ") 
med_y89/nrow(d89)*100
cat("     No = ") 
med_n89<-length(which(is.na(d89$MED)))
med_n89
cat("      % = ") 
med_n89/nrow(d89)*100


# Data fields
# (Use of) PRESCRIBED (medication): NA -> No, 1 -> Yes
cat("\n\n9. Used Prescribed Medication \n")
MED89<-d89[(!is.na(d89$MED)),]
cat("     Yes = ") 
presc_y89<-length(which(MED89$PRESCRIBED==1))
presc_y89
cat("       % = ") 
presc_y89/nrow(MED89)*100
cat("     No = ") 
presc_n89<-length(which(MED89$PRESCRIBED!=1))
presc_n89
cat("      % = ") 
presc_n89/nrow(MED89)*100

# data fields
# PRE_ISI: Participants' ISI questionnaire results on the inclusion/exclusion stage (pretest)
cat("\n\n10. Participants' PRE-ISI (n=89)\n")
cat("     Mean = ") 
mean(d89$PRE_ISI)
cat("     SD = ") 
sd(d89$PRE_ISI)

cat("\n\n################ End of Participant Demographics Analysis ################### \n")

######### stop redirecting output.
sink()
